/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.core.model.PortableGit;
import com.aptana.git.ui.Messages;
import com.aptana.git.ui.internal.CachedImageDescriptor;
import com.aptana.git.ui.internal.GitColors;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.IDialogConstants;
import com.aptana.ui.PopupSchedulingRule;
import com.aptana.ui.util.UIUtils;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class GitUIPlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "com.aptana.git.ui";
    private static GitUIPlugin plugin;
    private QuickDiffColorer themeChangeListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job job = new Job("Run any work in a delayed job to avoid slowing startup!"){

            protected IStatus run(IProgressMonitor monitor) {
                if (GitUIPlugin.this.themeChangeListener == null) {
                    GitUIPlugin.this.themeChangeListener = new QuickDiffColorer();
                }
                InstanceScope.INSTANCE.getNode("com.aptana.theme").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)GitUIPlugin.this.themeChangeListener);
                GitUIPlugin.this.themeChangeListener.forceColors();
                GitUIPlugin.this.checkHasGit();
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.themeChangeListener != null) {
                InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.themeChangeListener);
            }
            this.themeChangeListener = null;
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    private void checkHasGit() {
        if (this.getPreferenceStore().getBoolean("ignore_no_git")) {
            return;
        }
        if ("win32".equals(Platform.getOS()) && GitExecutable.instance() == null) {
            GitInstallationValidatorJob job = new GitInstallationValidatorJob(Messages.GitUIPlugin_GitInstallationValidator);
            job.setPriority(10);
            job.setRule((ISchedulingRule)PopupSchedulingRule.INSTANCE);
            job.schedule();
        }
    }

    public static GitUIPlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static Image getImage(String string) {
        ImageDescriptor id;
        ImageRegistry imageRegistry = GitUIPlugin.getDefault().getImageRegistry();
        if (imageRegistry.get(string) == null && (id = GitUIPlugin.imageDescriptorFromPlugin((String)GitUIPlugin.getPluginId(), (String)string)) != null) {
            imageRegistry.put(string, id);
        }
        return imageRegistry.get(string);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("icons/ovr/staged_added.gif", (ImageDescriptor)new CachedImageDescriptor(GitUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/ovr/staged_added.gif")));
        reg.put("icons/ovr/staged_removed.gif", (ImageDescriptor)new CachedImageDescriptor(GitUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/ovr/staged_removed.gif")));
        reg.put("icons/ovr/untracked.gif", (ImageDescriptor)new CachedImageDescriptor(GitUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/ovr/untracked.gif")));
    }

    private final class GitInstallationValidatorJob
    extends UIJob {
        private GitInstallationValidatorJob(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            block3: while (true) {
                MessageDialogWithToggle dlg = new MessageDialogWithToggle(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.GitUIPlugin_ConfiguringGitSupportTitle, null, Messages.GitUIPlugin_ConfigureGitPluginMessage, 2, new String[]{IDialogConstants.OK_LABEL}, 0, Messages.GitUIPlugin_ToggleMessage, false);
                int code = dlg.open();
                boolean toggleState = dlg.getToggleState();
                if (toggleState) {
                    GitUIPlugin.this.getPreferenceStore().setValue("ignore_no_git", dlg.getToggleState());
                }
                switch (code) {
                    case 0: {
                        if (!this.installPortableGit(monitor)) continue block3;
                        return Status.OK_STATUS;
                        if (!toggleState) continue block3;
                        return Status.OK_STATUS;
                    }
                }
                break;
            }
            return Status.OK_STATUS;
        }

        private boolean installPortableGit(IProgressMonitor monitor) {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(UIUtils.getActiveShell());
            try {
                dlg.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask(Messages.GitUIPlugin_ConfiguringGitSupport, -1);
                            monitor.worked(1);
                            PortableGit.install();
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            IPath path = PortableGit.getLocation();
            if (path != null) {
                GitExecutable.setPreferenceGitPath((IPath)path);
                return true;
            }
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GitUIPlugin_GitInstallError, (String)Messages.GitUIPlugin_GitConfigurationIncomplete);
            return false;
        }
    }

    private final class QuickDiffColorer
    implements IEclipsePreferences.IPreferenceChangeListener {
        private QuickDiffColorer() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!event.getKey().equals("THEME_CHANGED")) {
                return;
            }
            this.forceColors();
        }

        protected void forceColors() {
            UIUtils.runInUIThread((Runnable)new Runnable(){
                String greenBGString;
                String redBGString;

                public void run() {
                    RGB greenBG = GitColors.greenBG().getRGB();
                    this.greenBGString = StringConverter.asString((RGB)greenBG);
                    RGB redBG = GitColors.redBG().getRGB();
                    this.redBGString = StringConverter.asString((RGB)redBG);
                    JFaceResources.getColorRegistry().put("CONFLICTING_COLOR", redBG);
                    JFaceResources.getColorRegistry().put("RESOLVED_COLOR", greenBG);
                    this.setQuickDiffColors(InstanceScope.INSTANCE.getNode("com.aptana.editor.common"));
                    if (ThemePlugin.applyToAllEditors()) {
                        this.setQuickDiffColors(InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors"));
                    }
                }

                protected void setQuickDiffColors(IEclipsePreferences prefs) {
                    prefs.put("changeIndicationColor", this.greenBGString);
                    prefs.put("additionIndicationColor", this.greenBGString);
                    prefs.put("deletionIndicationColor", this.redBGString);
                    prefs.put("CONFLICTING_COLOR", this.redBGString);
                    prefs.put("RESOLVED_COLOR", this.greenBGString);
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e) {
                        IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                    }
                }
            });
        }
    }
}

